package demo.frame;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import demo.common.FunctionList;
import demo.common.IPCFaceMatchPanel;
import demo.common.LoginPanel;
import demo.common.Res;
import demo.module.LoginModule;
import demo.module.RealPlayModule;
import netsdk.lib.ToolKits;

import java.awt.FlowLayout;
import java.awt.BorderLayout;

class IPCFaceMatchFrame extends JFrame{
	private IPCFaceMatchPanel imp;
	private LoginPanel loginPanel;	
	
	public IPCFaceMatchFrame() {
		setTitle("IPCFaceMatch");
		//setLayout(null);
		//setLayout(new GridLayout(3, 1));
		setLayout(new BorderLayout());
//	    pack();
		setSize(800, 650);
		setLocationRelativeTo(null);										
		LoginModule.init();   // 打开工程，初始化
		loginPanel = new LoginPanel();
		//add(loginPanel);
		add(loginPanel, BorderLayout.NORTH);
		imp = new IPCFaceMatchPanel();
		//add(imp);
		add(imp, BorderLayout.CENTER);
		addWindowListener(new WindowAdapter() {
	    	public void windowClosing(WindowEvent e) {
	    		LoginModule.logout();
	    		LoginModule.cleanup();   // 关闭工程，释放资源
	    		dispose();		    		
	    		SwingUtilities.invokeLater(new Runnable() {
	    			public void run() {
	    				FunctionList demo = new FunctionList();
	    				demo.setVisible(true);
	    			}
	    		});
	    	}
	    });
		
		loginPanel.addLoginBtnActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {	   	    
				if(loginPanel.checkLoginText()) {
					if(login()) {
//						frame = ToolKits.getFrame(e);
//						frame.setTitle(Res.string().getFaceRecognition() + " : " + Res.string().getOnline());
					}
				}
			}
		});
	    
	    loginPanel.addLogoutBtnActionListener(new ActionListener() {		
			@Override
			public void actionPerformed(ActionEvent e) {
//				frame.setTitle(Res.string().getFaceRecognition());
				logout();	
			}
		});
	}
	// 登录
		public boolean login() {
			if(LoginModule.login(loginPanel.ipTextArea.getText(), 
							Integer.parseInt(loginPanel.portTextArea.getText()), 
							loginPanel.nameTextArea.getText(), 
							new String(loginPanel.passwordTextArea.getPassword()))) {
		
				loginPanel.setButtonEnable(true);
							
				setEnable(true);									
												
			} else {
				JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
				return false;
			}
			return true;
		}
		public void logout() {			
			LoginModule.logout();
			loginPanel.setButtonEnable(false);
			setEnable(false);						
//			globalPicShowPanel.setOpaque(true); 
//			globalPicShowPanel.repaint();															
		}
		
		private void setEnable(boolean bln) {
			
//			chnComboBox.setEnabled(bln);
//			realplayBtn.setEnabled(bln);
//			attachBtn.setEnabled(bln);
//			faceDataBaseBtn.setEnabled(bln);
//			faceEventRecordBtn.setEnabled(bln);
		}
}
public class IPCFaceMatch{
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				IPCFaceMatchFrame demo = new IPCFaceMatchFrame();
				demo.setVisible(true);
			}
		});
	}
}